#include "NetCtlStatus.h"
#include "MessagePipe.h"
#include "ErrorCodesSony.h"

namespace UnityPlugin
{
	int gNetCtlStatusCallbackID = 0;
	ResultCode gConnectionError = ResultCode("Connection");

	void NetCtlStatusCallback(int prev_state, int new_state, int event, int error_code, void *arg)
	{
		if (new_state == CELL_NET_CTL_STATE_Disconnected)
		{
			printf("NetCtlStatusCallback: CELL_NET_CTL_STATE_Disconnected\n");
			ErrorCode npError = NP_ERR_NOT_CONNECTED;
			gConnectionError.SetResult(npError, error_code, false, __FUNCTION__, __LINE__);
			UnityPlugin::Messages::AddMessage(UnityPlugin::Messages::kNPToolKit_ConnectionDown);
		}
		else if (new_state == CELL_NET_CTL_STATE_IPObtained)
		{
			gConnectionError.Reset();
		}
	}

	void RegisterNetCtlStatusCallback()
	{
		int ret = cellNetCtlAddHandler(NetCtlStatusCallback, NULL, &gNetCtlStatusCallbackID);
		if(ret != SCE_OK) 
		{
			printf("ERROR: Failed to register NetCtlStatus callback\n");
		}
	}

	DO_EXPORT( bool, PrxNetCtlGetLastConnectionError )(ResultCode* result)
	{
		*result = gConnectionError;
		return gConnectionError.GetResult() == NP_OK;
	}

};
